import sys
import math
import operator as op
import re

class Env(dict):
    def __init__(self, params=(), args=(),  outer=None, printme=True):
        self.outer = outer
        self.update(dict(zip(params, args)))

        # Print the env
        if printme:
            self.print()

    def print(self):
        #TODO
        #
        #
        #
        #
        #
        #
        #
        pass


    def find(self, name):
        if name in self:
            return self
        else:
            return self.outer.find(name)

class Procedure:
    def __init__(self, params, body, env):
        self.params = params
        self.body = body
        self.env = env

    def __call__(self, *args):
        local_env = Env(self.params, args, outer=self.env)
        return eval_expr(self.body,local_env)

    def __repr__(self):
        return "Procedure"


builtin_env = Env(printme=False)
builtin_env.update({k:v for k, v in vars(math).items() if not k.startswith('_')})
builtin_env['+'] = op.add
builtin_env['-'] = op.sub
builtin_env['/'] = op.truediv
builtin_env['*'] = op.mul
builtin_env['<'] = op.lt
builtin_env['>'] = op.gt
builtin_env['>='] = op.ge
builtin_env['<='] = op.le
builtin_env['='] = op.eq
builtin_env['display'] = print
builtin_env['version'] = '0.0.0'

global_env = Env(outer=builtin_env, printme=False)

def tokenize(source):
    # https://regex101.com/
    source = re.sub(';.*$', ' ', source, flags=re.MULTILINE)
    return source.replace('(', ' ( ').replace(')', ' ) ').split()

def parse_expr(tokens):
    if len(tokens) == 0:
        raise SyntaxError("EOF")

    token = tokens.pop(0)
    if token == '(':
        thelist = []
        while tokens[0] != ')':
            subexpr = parse_expr(tokens)
            thelist.append(subexpr)
        tokens.pop(0)
        return thelist
    else:
        try:
            return int(token)
        except ValueError:
            try:
                return float(token)
            except ValueError:
                return token



def eval_expr(expression, env=global_env):
    if isinstance(expression, str):
        name = expression
        declaring_scope = env.find(name)
        return declaring_scope[name]
    elif not isinstance(expression, list):
        return expression

    # Expression is  alist
    op, *args = expression

    if op == 'define':
        name, value = args
        global_env[name] = eval_expr(value, env)
        return None
    elif op == 'if':
        test, thenpart, elsepart = args
        evaluated_test = eval_expr(test, env)
        return eval_expr(thenpart, env) if evaluated_test else eval_expr(elsepart, env)
    elif op == 'quote':   # (quote hello) ==>  hello
        return args[0]
    elif op == 'lambda':
        params, body = args
        return Procedure(params, body, env)
    else:
        proc = eval_expr(op, env)
        evaluated_args = [eval_expr(arg, env) for arg in args]
        result = proc(*evaluated_args)
        return result


if __name__ == '__main__':
    source = open(sys.argv[1]).read()
    tokens = tokenize(source)
    while len(tokens) > 0:
        expr= parse_expr(tokens)
        print(">>>", expr)
        result = eval_expr(expr, global_env)
        if result is not None:
            print(result)